#ifndef _SAVEDCONNECTION_H
#define _SAVEDCONNECTION_H

#include "Array.h"
#include "Information.h"

class SavedConnection
{

	public:
		SavedConnection();
		SavedConnection(int capacity);
		virtual ~SavedConnection();

	public:
		SavedConnection(const SavedConnection& source);
		SavedConnection& operator=(const SavedConnection& source);

	public:
		Information& operator[](int index);
		Information* operator++(int);
		Information* operator--(int);
		Information* operator+(int index);
		Information* operator-(int index);

	public:
		int RecordInformation(Information& informatino);
		int FindInformationByTitle(QString& title);
		int EraseInformation(int index);
		int CorrectInformation(int index, Information& information);

	public:
		int GetLength() const;

	private:
		int length;
		Array<Information> informations;

};

inline int SavedConnection::GetLength() const
{
	return this->length;
}

int CompareByTitle(void* one, void* other);

#endif //_SAVEDCONNECTION_H
